;ebay lcd on 2313
;SERIAL I/F TO EBAY LCD
; displays sponge bob with bit banged spi
; 11/29/07
;

.NOLIST
.include "2313def.inc"
.LIST

.ORG    $0000 
	RJMP   RESET_VEC        ;Reset Handle
	

.EQU	LCDD =	PORTB	;
.EQU    	DDR_LCDD =	DDRB 	;data direction register b

;no connections to port D

; BIT EQUATES FOR CONTROL PORT
; ZERO, ONE AND SIX ARE NC
.EQU	BRES=	2	;reset used on pup only
.EQU	BCS=	3	;chip select- act low
.EQU	BA0=	4	;a0 cmd hi/cmd lo
.EQU	BDO=	5	;data pin
.EQU	BCLK=	7	;bit bang clock

.DEF	JON   =	R16	;fill debug var
.DEF    TEMP  =	R19
.DEF    TEMP1 =	R20 
.DEF	DDATA =	R21	;display data
.DEF	COLAD = R22	;col add
.DEF	TOOT  =	R23	;working reg temp
.DEF	PAGAD =	R24

;26 AND 27 ARE USED IN DELAY ROUTINE

;code begin

RESET_VEC:	
;stack ptr
	LDI	TEMP,LOW(RAMEND)
            OUT	SPL,TEMP	     
            LDI	TEMP,HIGH(RAMEND)
            OUT	SPL+1,TEMP	

;default port values before ddr's	
	CLR	TEMP		;all low
	OUT	LCDD,TEMP

	LDI	TEMP,0X7F		;inputs with pullups
	OUT	PORTD,TEMP

;port ddr's
	LDI	TEMP,0XFF		;all outs
            OUT	DDR_LCDD,TEMP

	LDI	TEMP,0X00		;all inputs- 
	OUT	DDRD,TEMP
      
;*************************************************************
;LCD TEST CODE- DEBUG SINGLE STEP
;FROM 8-57

	CBI	LCDD,BRES	;RESET LOW
	RCALL    	DELAY       ;delay for PS stable from docs
	SBI	LCDD,BRES	;RESET HIGH
;LCD controller reset


;soft reset command too
	LDI	DDATA,0XE2
	RCALL	TELL

;func setup 1 lcd bias  <1/7 bias, 65 duty>
	LDI	DDATA,0XA3
	RCALL	TELL	;disp write command A0 high

;func setup 2 adc select
	LDI	DDATA,0XA1
	RCALL	TELL

;func setup 3 com out state
	LDI	DDATA,0XC0	; 3 lsb's are don't uses
	RCALL	TELL

;func setup 4 resistor ratio
	LDI	DDATA,0X24
	RCALL	TELL	
		
;func setup 5 electronic volume control  (2 BYTES)
	LDI	DDATA,0X81
	RCALL	TELL
	LDI	DDATA,0X20
	RCALL	TELL

;func setup 6 power control setup
	LDI	DDATA,0X2F	
	RCALL	TELL


;end of display basic initialization
;***************************************************

;turn on display
	LDI	DDATA,0XAF
	RCALL	TELL	



;start line 0
	LDI	DDATA,0X40
	RCALL	TELL

;page address =0
	LDI	DDATA,0XB0
	RCALL	TELL
;****************************************************************
; DRAW IMAGE
	LDI	ZL,LOW(2*SPONG)	;POINT TO TABLE BASE ADDRESS
	LDI	ZH,HIGH(2*SPONG)
	CLR	TEMP
	CLR	PAGAD

LOPP:	LPM
	MOV	DDATA,R0
	RCALL	SHOW
	ADIW	ZL,0X01
	LDI	TEMP1,0
	ADC	ZH,TEMP1
	INC	TEMP
	CPI	TEMP,0X64
	BRNE	LOPP
	INC	PAGAD
	CPI	PAGAD,0X09
	BREQ	WAIT
	LDI	DDATA,0XB0
	OR	DDATA,PAGAD
	RCALL	TELL
	LDI	DDATA,0X10
	RCALL	TELL
	LDI	DDATA,0X00
	RCALL	TELL
	CLR	TEMP
	RJMP	LOPP



;****************************************************************


 WAIT:	RJMP	WAIT
;***************************************************
;*                DELAY TIME FOR START             *
;***************************************************
DELAY:	LDI	R27,0XFF
DEL2:	LDI	R26,0XFF
DEL1:	DEC	R26
	BRNE	DEL1
	DEC	R27
	BRNE	DEL2
	RET
;***************************************************
; LCD LOW LEVEL ROUTINES
;***************************************************
;
;
SHOW:	LDI	TEMP1,0x1C	;A0 HIGH = DATA
	RJMP	PTEL

TELL:	LDI	TEMP1,0X0C	;A0 LOW  = CMD


PTEL:	OUT	LCDD,TEMP1	;start with cmd/data and cs low
	LDI	R27,0X08	;bit counter
;data is in ddata
LPLCD:	LSL	DDATA	;shift left
	BRCC	DLO	;carry to mosi
	SBI	LCDD,BDO	;set bit
	RJMP	DBIT		
DLO:	CBI	LCDD,BDO	
DBIT:	NOP		;delay
	SBI	LCDD,BCLK	;clock
	NOP
	CBI	LCDD,BCLK	;clock low
	DEC	R27
	BRNE	LPLCD	;loop 8 times
	CBI	LCDD,BCS
	RET

;set column from column address
SETCL:	MOV	DDATA,COLAD
	ANDI	DDATA,0XF0
	SWAP	DDATA
	ORI	DDATA,0X10
	RCALL	TELL
	MOV	DDATA,COLAD
	ANDI	DDATA,0X0F
	RCALL	TELL
	RET

;;;;;;;;;;;;;;;;;;;
; send spid
;wzero:	ldi	spid,0		;entry for zero
;wrspi:	ldi	rctr,8		;8 bits count
;lwspi:	lsl	spid		;shift left
;	brcc	dlo		;move carry to mosi
;	sbi	portb,cmo
;	rjmp	dbit		
;dlo:	cbi	portb,cmo
;dbit:	rcall	dl35		;
;	sbi	portb,cck	;card clock high
;	rcall	dl35			;little delay
;	cbi	portb,cck	;card clock low
;	rcall	dl35	
;	dec	rctr
;	brne	lwspi		;loop 8 times
;	ret			;done		




;IMAGE FILE
 .ORG 0X200
 SPONG:

.DB 0x00,0x00,0x00,0xFE,0xFE,0xFE,0xFE,0xFE,0x0C,0x3C,0xF6,0xC2,0x02,0x00,0x00,0xFE
.DB 0xFE,0xFE,0xFE,0xFE,0x00,0x00,0x80,0xF0,0xFE,0xFE,0xFC,0xF8,0xE0,0x70,0xFC,0xFE
.DB 0xFE,0xF0,0x80,0x00,0x00,0xFE,0xFE,0xFE,0xFE,0xFE,0x42,0x42,0x46,0xFC,0xB8,0x00
.DB 0x00,0xFE,0xFE,0xFE,0xFE,0xFE,0x12,0x12,0x12,0x12,0x12,0x00,0xFE,0xFE,0xFE,0xFE
.DB 0xFE,0x82,0x02,0x86,0xFC,0x78,0x00,0x00,0xFE,0xFE,0xFE,0xFE,0xFE,0x00,0x00,0x00
.DB 0x00,0x00,0x02,0x06,0x0E,0x1E,0x7E,0xFE,0xFC,0xF8,0x38,0x1C,0x06,0x02,0x00,0x00
.DB 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07,0x07,0x00,0x00,0x00,0x01
.DB 0x07,0x06,0x00,0x07,0x07,0x07,0x07,0xE7,0xE0,0xE6,0xE7,0xE1,0x20,0x21,0x63,0xC3
.DB 0x81,0x00,0x03,0x07,0x07,0x07,0x07,0xC4,0xE0,0xE7,0x87,0x07,0x07,0x07,0x04,0x04
.DB 0xE6,0xE7,0xE3,0xE0,0xE0,0x27,0x27,0x67,0xC7,0x87,0x04,0x24,0x24,0x24,0xE4,0xE0
.DB 0xE7,0xE7,0xE7,0x27,0x27,0x23,0x07,0xE7,0xE4,0xE0,0xE0,0xE0,0x07,0x07,0x07,0xE7
.DB 0xE7,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x06,0x07,0x01,0x00,0x00,0x00
.DB 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.DB 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x7F,0x7F,0x7F
.DB 0x44,0x44,0x64,0x7F,0x3B,0x00,0x40,0x70,0x38,0x3E,0x27,0x27,0x3F,0x7F,0x7F,0x7E
.DB 0x7C,0x70,0x40,0x00,0x7F,0x7F,0x7F,0x7F,0x7F,0x38,0x70,0x78,0x4F,0x07,0x00,0x00
.DB 0x00,0x00,0x7F,0x7F,0x7F,0x7F,0x7F,0x00,0x00,0x00,0x00,0x7F,0x7F,0x7F,0x7F,0x7F
.DB 0x01,0x01,0x01,0x7F,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.DB 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.DB 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xF0,0xF8,0xFC
.DB 0xFC,0x04,0x04,0x0C,0x0C,0x18,0x10,0x00,0xFC,0xFC,0xFC,0xFC,0xFC,0x00,0x00,0x00
.DB 0xFC,0xFC,0x00,0x00,0xFC,0xFC,0xFC,0xFC,0xFC,0x04,0x04,0x0C,0xF8,0xF0,0x00,0x00
.DB 0xFC,0xFC,0xFC,0xFC,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC,0xFC,0xFC,0xFC
.DB 0x00,0x00,0xFC,0xFC,0xF8,0xF0,0xF0,0xE0,0xE0,0xC0,0xFC,0xFC,0x00,0x00,0x00,0x00
.DB 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.DB 0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0x80,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0xC0
.DB 0xC1,0x07,0xC7,0xCF,0xCF,0xC8,0xC8,0x4C,0x4C,0x46,0x42,0x40,0x47,0x47,0x4F,0xCF
.DB 0xCF,0xC8,0xC8,0xCC,0x47,0x43,0x40,0x40,0x4F,0x4F,0xCF,0xCF,0xCF,0xC7,0xCE,0x4F
.DB 0x49,0x40,0x00,0xC0,0xCF,0xCF,0xCF,0xCF,0x4F,0x48,0xC8,0x88,0x08,0x08,0x00,0x0F
.DB 0x8F,0x8F,0xCF,0xCF,0x40,0xC0,0x8F,0x8F,0x00,0x01,0x41,0x43,0x43,0xC7,0xCF,0xCF
.DB 0xC0,0xC0,0x00,0x00,0x00,0x00,0xC0,0xC0,0xC0,0xC0,0xC0,0x00,0x00,0x00,0xC0,0xC0
.DB 0xC0,0xC0,0x00,0x00,0x01,0x01,0x01,0x0F,0x3F,0xFF,0xFF,0x7E,0x3E,0x1F,0x7F,0xFF
.DB 0xFF,0x7C,0x0F,0x03,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x82,0x82,0x82,0x82,0x82
.DB 0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF
.DB 0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x70,0xE0,0xF0,0x9F
.DB 0x0F,0x00,0x00,0x1E,0x7F,0x7F,0xFF,0xFF,0x80,0xC0,0x61,0x7F,0x1E,0x00,0x00,0x00
.DB 0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x02
.DB 0x02,0x02,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0xF8
.DB 0xF8,0xF8,0xF8,0x01,0x01,0x00,0xC0,0xE0,0xF8,0xE0,0x80,0x00,0x00,0x00,0xF8,0xF0
.DB 0xF0,0xE0,0xE0,0xC0,0x80,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0xF0,0xF8,0xF8
.DB 0xF8,0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,0xF0,0xF8,0x00,0x00,0x00,0x00,0x00,0x00
.DB 0x00,0x00,0x00,0x00,0x00,0x00,0x10,0xF0,0xF8,0xF8,0xF8,0x00,0x00,0x00,0xF0,0x08
.DB 0xF8,0xF8,0xF0,0xE0,0x00,0x00,0x80,0x30,0x28,0x28,0xE8,0xE8,0xC8,0x80,0x00,0x08
.DB 0x08,0x08,0x88,0xE8,0xF8,0xF8,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04
.DB 0x08,0x08,0x08,0x0F,0x0F,0x07,0x03,0x08,0x06,0x05,0x04,0x07,0x0F,0x0F,0x0F,0x0E
.DB 0x08,0x00,0x0F,0x00,0x01,0x01,0x03,0x07,0x07,0x0F,0x00,0x00,0x00,0x00,0x00,0x00
.DB 0x00,0x0F,0x0F,0x0F,0x0F,0x00,0x00,0x06,0x05,0x04,0x0F,0x0F,0x0F,0x0F,0x04,0x00
.DB 0x00,0x2C,0x2C,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0F,0x00
.DB 0x00,0x00,0x05,0x09,0x0F,0x0F,0x07,0x03,0x00,0x00,0x07,0x04,0x08,0x08,0x0F,0x0F
.DB 0x07,0x03,0x00,0x00,0x08,0x0E,0x0F,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00





















;SPONGE BOB GRAPHIC
; .DB 0X00,0XF0,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X80,0X80,0X80,0X00,0X00
; .DB 0X80,0X00,0X00,0X00,0X80,0X00,0X00,0X00,0X80,0X00,0X00,0X80,0X80,0X00,0XF0,0X00
; .DB 0X00,0X80,0X00,0X00,0X00,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X20,0XD0,0X00
; .DB 0X10,0X90,0X10,0XE8,0X08,0X08,0XC0,0XA8,0X88,0XE8,0X84,0X84,0X84,0XC8,0X08,0X28
; .DB 0X04,0X04,0XC4,0X80,0X84,0XE4,0X84,0XA4,0XC4,0X0A,0X02,0X02,0X04,0X22,0X12,0X82
; .DB 0X52,0X22,0XC2,0X3A,0X04,0X08,0X10,0X10,0X20,0X60,0X80,0X80,0X00,0X00,0X00,0X00
; .DB 0X00,0X00,0X00,0X00,0X00,0X3F,0X01,0X01,0X01,0X01,0X01,0X3F,0X00,0X00,0X1F,0X20
; .DB 0X20,0X20,0X1F,0X00,0X01,0X0E,0X30,0X0E,0X01,0X0E,0X30,0X0E,0X01,0X00,0X1F,0X20
; .DB 0X20,0X21,0X3F,0X00,0X00,0X01,0X0E,0XF0,0X0E,0X01,0X00,0X00,0X00,0X00,0X00,0X00
; .DB 0X00,0X80,0X7D,0X82,0X11,0X2A,0X12,0XE1,0X8C,0X82,0X01,0X20,0X00,0X90,0X68,0X68
; .DB 0X50,0XA1,0X03,0X8E,0X02,0X09,0X01,0XB2,0X60,0XE8,0X88,0XA0,0X00,0X01,0X02,0X88
; .DB 0X60,0X80,0X00,0XA0,0X00,0XB0,0X0D,0X0A,0X0E,0X91,0X21,0X20,0X41,0X2A,0X80,0X20
; .DB 0X11,0X0E,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00
; .DB 0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00
; .DB 0X00,0X00,0X80,0X80,0X00,0X80,0X00,0X00,0X00,0X01,0X01,0X00,0X00,0X00,0X00,0X00
; .DB 0X00,0X00,0X00,0X00,0X00,0X80,0X00,0XBB,0X00,0X00,0X00,0X07,0X0C,0X88,0XD9,0XA1
; .DB 0X22,0XA0,0X25,0X28,0X48,0X08,0X48,0X06,0X04,0X08,0X08,0X88,0X90,0X91,0XD1,0XCE
; .DB 0XCA,0XEA,0X19,0X0B,0X22,0X16,0X08,0XA0,0XD0,0X0A,0X50,0X80,0X00,0X10,0X2D,0X89
; .DB 0X12,0XA8,0X18,0X02,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00
; .DB 0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00
; .DB 0X00,0X00,0X41,0XAA,0X4E,0X93,0X30,0X82,0X60,0X08,0X09,0X09,0X09,0X0A,0X0A,0X0A
; .DB 0X0A,0X08,0X1C,0X14,0X14,0X28,0XEC,0XAA,0X82,0X80,0X84,0X8A,0X7C,0X08,0X20,0X88
; .DB 0X40,0X80,0X80,0X80,0X07,0X89,0XF9,0XF9,0X79,0XFF,0X7F,0XB9,0XF9,0X39,0X3D,0X3F
; .DB 0XBF,0XFF,0X1F,0X8F,0X03,0XA8,0X10,0X08,0X10,0XA0,0X00,0XA0,0X0F,0X00,0X00,0X80
; .DB 0X41,0X8A,0X11,0XA8,0X30,0XAE,0XA1,0XE0,0X80,0X80,0X80,0X80,0X00,0X00,0X00,0X00
; .DB 0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X80
; .DB 0X40,0X20,0X10,0X00,0X90,0X00,0X00,0X00,0X81,0X81,0X01,0XF0,0X00,0X00,0X00,0X80
; .DB 0X80,0X80,0X00,0X00,0X00,0XF0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00
; .DB 0X0F,0XB0,0X15,0X18,0X10,0X90,0X11,0X20,0X20,0X26,0X99,0XAB,0X6A,0XAA,0X0C,0XAA
; .DB 0X72,0XAA,0X29,0XA9,0XC0,0X80,0X40,0X8A,0X52,0X48,0X42,0X22,0X42,0X01,0X40,0XEA
; .DB 0X40,0X20,0X20,0X23,0XA6,0XA4,0X54,0X28,0X28,0XAA,0X98,0X4E,0X4A,0X26,0X14,0X02
; .DB 0X09,0X0D,0X02,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X3F
; .DB 0X04,0X02,0X03,0X04,0X08,0X10,0X20,0X00,0X3F,0X00,0X00,0X1F,0X20,0X20,0X21,0X3F
; .DB 0X00,0X00,0X13,0X24,0X24,0X24,0X19,0X00,0X00,0X2F,0X00,0X00,0X00,0X00,0X00,0X00
; .DB 0X00,0X00,0X00,0X00,0X00,0X3B,0X20,0X22,0X27,0XA6,0X47,0XA2,0X41,0X47,0X44,0X46
; .DB 0X45,0XCB,0X50,0XC3,0XCE,0X8E,0X4D,0X8E,0X80,0X8A,0X8A,0X8A,0X8C,0X8A,0X98,0X8A
; .DB 0X80,0X82,0X9D,0X82,0X82,0X8A,0X8E,0X9B,0X50,0X20,0X20,0X28,0X17,0X0A,0X00,0X00
; .DB 0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0XF8,0X80,0X00,0X00,0XF0,0X38,0XF0
; .DB 0X00,0X00,0X80,0XF8,0X00,0X00,0XF8,0X80,0X00,0X00,0XF0,0X38,0XF0,0X00,0X00,0X80
; .DB 0XF8,0X00,0X00,0X20,0XF0,0X80,0X88,0X08,0X10,0X00,0X00,0X00,0XF8,0XF8,0X88,0X88
; .DB 0X88,0X70,0X20,0X00,0X00,0XF8,0XF8,0X08,0X08,0X00,0XF0,0X80,0X00,0X00,0X00,0X03
; .DB 0X02,0X02,0X02,0X2E,0XE6,0XBE,0X82,0X22,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00
; .DB 0X07,0X00,0X04,0X38,0XCD,0XB8,0X85,0X00,0X02,0X0A,0X00,0X00,0X00,0X00,0X00,0X00
; .DB 0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0F,0X1C
; .DB 0X0F,0X00,0X00,0X00,0X0F,0X1C,0X1F,0X00,0X00,0X00,0X00,0X0F,0X1C,0X0F,0X00,0X00
; .DB 0X00,0X0F,0X1C,0X1F,0X00,0X00,0X00,0X00,0X08,0X10,0X11,0X01,0X0F,0X04,0X00,0X00
; .DB 0X1F,0X1F,0X10,0X10,0X10,0X0F,0X06,0X00,0X00,0X1F,0X1F,0X10,0X10,0X00,0X0F,0X01
; .DB 0X00,0X60,0X70,0X60,0X30,0X20,0X40,0X60,0X7D,0X68,0X7F,0X60,0X00,0X00,0X00,0X00
; .DB 0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X02,0X7F,0X0A,0X7F,0X00,0X00,0X00,0X00,0X00
; .DB 0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00
